-- MOD per DCS WORLD 
-- Amphibious Ship, USS Oak Hill LSD-51 by Admiral189 

-----             USS Oak Hill LSD-51 Shapes --------------------------------------------------
mount_vfs_model_path	(current_mod_path.."/Shapes/")

-----             USS Oak Hill LSD-51 Textures ---------------------------------------------------
mount_vfs_texture_path  (current_mod_path.."/Textures/")
mount_vfs_texture_path  (current_mod_path.."/Textures/textures")

GT = {};
GT_t.ws = 0;

set_recursive_metatable(GT, GT_t.generic_ship)

GT.visual = {}
GT.visual.shape = "USS Oak Hill LSD-51"
GT.visual.shape_dstr = ""

GT.animation_arguments.radar1_rotation = 21; 
GT.radar1_period = 1;
GT.animation_arguments.radar2_rotation = 22;
GT.radar2_period = 2 
GT.animation_arguments.radar3_rotation = 23;
GT.radar3_period = 1 
GT.animation_arguments.luna_lights = -1;

GT.animation_arguments.flag_animation = 11;
GT.animation_arguments.water_propeller = 30;
GT.animation_arguments.flight_deck_fences = 150


GT.life = 2700;
GT.mass = 9.59e+006;
GT.max_velocity = 15.4333
GT.race_velocity = 15.4333
GT.economy_velocity = 10.2889
GT.economy_distance = 1.1112e+007
GT.race_distance = 2.778e+006
GT.shipLength = 138.5
GT.Width = 15
GT.Height = 37.2
GT.Length = 138.8
GT.DeckLevel = 8
GT.X_nose = 87.329
----GT.X_tail = -85.9824  Valore Originale
GT.X_tail = -82.227
GT.Tail_Width = 15
GT.Gamma_max = 0.35
GT.Om = 0.05
GT.speedup = 0.229734
GT.R_min = 345.6
GT.distFindObstacles = 568.4

GT.airWeaponDist = 100000
GT.airFindDist = 150000



-- Aircraft complement
GT.numParking = 2
GT.Helicopter_Num_ = 2   -- Real value = 2 Helicopters

--GT.Landing_Point = {-37.315, 12.1, 0.0}
--GT.Landing_Point = {-71.615, 16.1, 0.0};

local deck_level_f = 13.0 - 0.9
local deck_level_r = deck_level_f + 0.3

GT.DeckLevel       = deck_level_f;
GT.Landing_Point   = {-66.6, deck_level_r,  1.0}

GT.RunWays =
{
    -- landing strip definition (first in table)
    --  VppStartPoint;            azimuth (degree}   Length_Vpp;     Width_Vpp;
    {{-66.6, deck_level_f,  3.5},         0.0,             5.0,          14.0,         
    -- alsArgument, lowGlidePath, slightlyLowGlidePath, onLowerGlidePath, onUpperGlidePath, slightlyHighGlidePath, highGlidePath
       0,             2.5,              2.8,               3.0,               3.0,                 3.2,               3.5 },
    -- runways
    {{-31.5, deck_level_f, - 3.5},         0.0,             5.0,          14.0,         0, 2.5, 2.8, 3.0, 3.0, 3.2, 3.5},
    {{-66.6, deck_level_r,   3.5},         0.0,             5.0,          14.0,         0, 2.5, 2.8, 3.0, 3.0, 3.2, 3.5},
};
GT.RunWays.RunwaysNumber = #GT.RunWays

GT.TaxiRoutes = 
{
    -- taxi routes and parking spots 
    --    {x, y, z},  direction
}
GT.TaxiRoutes.RoutesNumber = #GT.TaxiRoutes


GT.HelicopterSpawnTerminal = 
{
    -- taxi routes and parking spots in LCS
    --    {x, y, z},  direction
    {
        TerminalIdx = 1, Points =
        { -- 1 spawn spot
            {{-31.5, deck_level_f,   0.0},   0.0},
        }
    },
    {
        TerminalIdx = 2, Points =
        { -- 1 spawn spot
            {{-66.6, deck_level_r,   0.0},   0.0},
        }
    },
}
GT.HelicopterSpawnTerminal.TerminalNumber = #GT.HelicopterSpawnTerminal

-- Engine        14.346   17.538    22.005   27.521
GT.exhaust = {
	[1] = { size = 0.20 , pos = {-18.50, 22.521, -9.688 } },
	[2] = { size = 0.20 , pos = {14.45, 27.533, 10.702 } },
	--[1] = { size = 0.20 , pos = {13.743, 27.521, -10.208} },
	--[2] = { size = 0.20 , pos = {-17.437, 22.005, 9.688} },
	
}

GT.DM = {
	{ area_name = "Command", 	area_arg = 79,	area_life = 110, area_fire = { pos = {0.0, 3.0, 8.0}, size = 0.8}},
	{ area_name = "Portside", 	area_arg = 80,	area_life = 110, area_fire = { pos = {0.0, 3.0, 8.0}, size = 0.8}},
	{ area_name = "Shipshull", 		area_arg = 81,	area_life = 110, area_fire = { pos = {0.0, 3.0, 8.0}, size = 0.8}},
	{ area_name = "Stbdside", 		area_arg = 82,	area_life = 110, area_fire = { pos = {0.0, 3.0, 8.0}, size = 0.8}},
    { area_name = "STBDSIDE_ZA",	area_arg = 83,	area_life = 110, area_fire = { pos = {-12.7, 1.0, -5.7}, size = 0.8}},
    { area_name = "PORTSIDE_ZA", 	area_arg = 84,	area_life = 110, area_fire = { pos = {-70.0, 2.0, 7.7}, size = 0.8}},
    { area_name = "KABINA", 		area_arg = 85,	area_life = 110, area_fire = { pos = {0.0, 2.0, -8.0}, size = 0.8}},
	{ area_name = "ZA_F", 		    area_arg = 86,	area_life = 110, area_fire = { pos = {50.0, 4.0, -5.0}, size = 0.8}},
    { area_name = "ZA_R", 		    area_arg = 87,	area_life = 110, area_fire = { pos = {0.0, 2.0, -8.0}, size = 0.8}},
	{ area_name = "ZA_FAF", 		area_arg = 88,	area_life = 110, area_fire = { pos = {50.0, 4.0, -5.0}, size = 0.8}},
    { area_name = "ZA_FAR", 		    area_arg = 89,	area_life = 110, area_fire = { pos = {0.0, 2.0, -8.0}, size = 0.8}},
	{ area_name = "STBDSIDE_ZAB", 		area_arg = 90,	area_life = 110, area_fire = { pos = {50.0, 4.0, -5.0}, size = 0.8}},
    { area_name = "PORTSIDE_ZAC", 		area_arg = 91,	area_life = 110, area_fire = { pos = {0.0, 2.0, -8.0}, size = 0.8}},
	{ area_name = "STBDSIDE_ZAR",		 area_arg = 92,	area_life = 110, area_fire = { pos = {-12.7, 1.0, -5.7}, size = 0.8}},
    { area_name = "PORTSIDE_ZAL", 		 area_arg = 93,	area_life = 110, area_fire = { pos = {-70.0, 2.0, 7.7}, size = 0.8}},
	{ area_name = "FWD_CAM", 		 area_arg = 94,	area_life = 110, area_fire = { pos = {-70.0, 2.0, 7.7}, size = 0.8}},
	{ area_name = "AFT_CAM", 		 area_arg = 95,	area_life = 110, area_fire = { pos = {-70.0, 2.0, 7.7}, size = 0.8}},
 }

GT.driverViewConnectorName = {"DRIVER_POINT", offset = {0.0, 0.0, 0.0}}
GT.driverCockpit = "DriverCockpit/DriverCockpitWithIR" 
	 
-- weapon systems
GT.WS = {}
local ws;
GT.WS.maxTargetDetectionRange = 450000;
GT.WS.radar_type = 102
GT.WS.searchRadarMaxElevation = math.rad(60);

-- CIWS Phalanxs
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.phalanx )
GT.WS[ws].area = 'ZA_F'
GT.WS[ws].center = 'CENTER_TOWER_01'
GT.WS[ws].drawArgument1 = 1
GT.WS[ws].drawArgument2 = 2
GT.WS[ws].angles[1][1] = math.rad(0);
GT.WS[ws].angles[1][2] = math.rad(180);
GT.WS[ws].reference_angle_Y = math.rad(0);
GT.WS[ws].LN[1].fireAnimationArgument = 118;
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_GUN_01'


-- CIWS Phalanxs
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.phalanx )
GT.WS[ws].area = 'ZA_R'
GT.WS[ws].center = 'CENTER_TOWER_02'
GT.WS[ws].drawArgument1 = 3
GT.WS[ws].drawArgument2 = 4
GT.WS[ws].angles[1][1] = math.rad(0);
GT.WS[ws].angles[1][2] = math.rad(180);
GT.WS[ws].reference_angle_Y = math.rad(180);
GT.WS[ws].LN[1].fireAnimationArgument = 119;
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_GUN_02'

-- Bushmaster Autogun
local ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].center = 'CENTER_TOWER_03'
GT.WS[ws].angles = {
					{math.rad(180), math.rad(-180), math.rad(-5), math.rad(70)},
					};
GT.WS[ws].drawArgument1 = 5
GT.WS[ws].drawArgument2 = 6
GT.WS[ws].omegaY = math.rad(60)
GT.WS[ws].omegaZ = math.rad(30)

__LN = add_launcher(GT.WS[ws], GT_t.LN_t.machinegun_12_7_utes);
__LN.BR[1].connector_name = 'POINT_GUN_03';
for i=7,10 do
	__LN.PL[i] = {}
	set_recursive_metatable(__LN.PL[i], __LN.PL[1]);
end
__LN.fireAnimationArgument = 44;

local ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].center = 'CENTER_TOWER_04'
GT.WS[ws].angles = {
					{math.rad(180), math.rad(-180), math.rad(-5), math.rad(70)},
					};
GT.WS[ws].drawArgument1 = 7
GT.WS[ws].drawArgument2 = 8
GT.WS[ws].omegaY = math.rad(60)
GT.WS[ws].omegaZ = math.rad(30)

__LN = add_launcher(GT.WS[ws], GT_t.LN_t.machinegun_12_7_utes);
__LN.BR[1].connector_name = 'POINT_GUN_04';
for i=7,10 do
	__LN.PL[i] = {}
	set_recursive_metatable(__LN.PL[i], __LN.PL[1]);
end
__LN.fireAnimationArgument = 45;

-- MiniGun Stbd
ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].center = 'CENTER_TOWER_05'
GT.WS[ws].area = 'STBDSIDE_ZA'   ----- Warning: the names in this line must be present in the GT.DM section
GT.WS[ws].drawArgument1 = 9
GT.WS[ws].drawArgument2 = 10
GT.WS[ws].angles = {
                   {math.rad(-170), math.rad(-0), math.rad(-5), math.rad(40)},
                    };
GT.WS[ws].reference_angle_Y = math.rad(0);
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.automatic_gun_25mm);
__LN.BR[1].connector_name = 'POINT_GUN_05'
__LN.fireAnimationArgument = 122;

-- MiniGun Port
ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].center = 'CENTER_TOWER_06'
GT.WS[ws].area = 'PORTSIDE_ZA'   ----- Warning: the names in this line must be present in the GT.DM section
GT.WS[ws].drawArgument1 = 26
GT.WS[ws].drawArgument2 = 27
GT.WS[ws].angles = {
                   {math.rad(-170), math.rad(-0), math.rad(-5), math.rad(40)},
                    };
GT.WS[ws].reference_angle_Y = math.rad(0);
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.automatic_gun_25mm);
__LN.BR[1].connector_name = 'POINT_GUN_06'
__LN.fireAnimationArgument = 123;

-- MiniGun Stbd
ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].center = 'CENTER_TOWER_07'
GT.WS[ws].area = 'STBDSIDE_ZAR'   ----- Warning: the names in this line must be present in the GT.DM section
GT.WS[ws].drawArgument1 = 13
GT.WS[ws].drawArgument2 = 14
GT.WS[ws].angles = {
                   {math.rad(-170), math.rad(-0), math.rad(-5), math.rad(40)},
                    };
GT.WS[ws].reference_angle_Y = math.rad(0);
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.automatic_gun_25mm);
__LN.BR[1].connector_name = 'POINT_GUN_07'
__LN.fireAnimationArgument = 124;

-- MiniGun Port
ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].center = 'CENTER_TOWER_08'
GT.WS[ws].area = 'PORTSIDE_ZAL'   ----- Warning: the names in this line must be present in the GT.DM section
GT.WS[ws].drawArgument1 = 15
GT.WS[ws].drawArgument2 = 16
GT.WS[ws].angles = {
                   {math.rad(-170), math.rad(-0), math.rad(-5), math.rad(40)},
                    };
GT.WS[ws].reference_angle_Y = math.rad(0);
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.automatic_gun_25mm);
__LN.BR[1].connector_name = 'POINT_GUN_08'
__LN.fireAnimationArgument = 125;


-- 9 AIGES trackers
ws = GT_t.inc_ws();
local first_EGES_tracker_id = ws;
GT.WS[ws] = {
	omegaY = 2,
	omegaZ = 2,
	pidY = {p=100, i=0.05, d=12, inn = 50},
	pidZ = {p=100, i=0.05, d=12, inn = 50},
	area = 'KABINA',
	pos = {0.0, 19.0, 0.0},
	angles = { {math.rad(180), math.rad(-180), math.rad(-90), math.rad(80)} },
	LN = {
		[1] = {
			type = 102,
			distanceMin = 1000,
			distanceMax = 150000,
			reactionTime = 2.0,
			reflection_limit = 0.1,
			ECM_K = 0.5,
			min_trg_alt = 5,
			max_trg_alt = 30000,
			max_number_of_missiles_channels = 2
		}
	}
};
local AIGES_TRACKERS = {{{'self', ws}}}

for i=2,9 do
	ws = GT_t.inc_ws();
	GT.WS[ws] = {};
	set_recursive_metatable(GT.WS[ws], GT.WS[first_EGES_tracker_id]);
	table.insert(AIGES_TRACKERS, {{'self', ws}})
end;

--------------------------------------------------------------------------------
-- Mk 57 Mod3 Sea Sparrow (RAM system)
-- Forward Center
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.seasparrow)
GT.WS[ws].area = 'ZA_FAF'
GT.WS[ws].center = 'CENTER_TOWER_09'--POINT CONNECTOR NAME REQUIRED.... NEEDS TO BE PLACED AT CENTER POINT OF THE FRONT SAM LAUNCHER 
GT.WS[ws].angles_mech = {
							{math.rad(180), math.rad(-180), math.rad(-5), math.rad(85)}
						}
GT.WS[ws].angles = {
					 {math.rad(180), math.rad(40), math.rad(45), math.rad(80)},
					 {math.rad(40), math.rad(-170), math.rad(-5), math.rad(80)},
				   }
GT.WS[ws].drawArgument1 = 17
GT.WS[ws].drawArgument2 = 18
GT.WS[ws].reference_angle_Y = math.rad(0)
GT.WS[ws].LN[1].min_launch_angle = math.rad(35);
GT.WS[ws].LN[1].BR = {
						{connector_name = 'Rocket_Point_20', drawArgument = 188},
						{connector_name = 'Rocket_Point_21', drawArgument = 189},
						{connector_name = 'Rocket_Point_22', drawArgument = 190},
						{connector_name = 'Rocket_Point_23', drawArgument = 191},
						{connector_name = 'Rocket_Point_24', drawArgument = 192},
						{connector_name = 'Rocket_Point_25', drawArgument = 193},
						{connector_name = 'Rocket_Point_26', drawArgument = 194},
						{connector_name = 'Rocket_Point_27', drawArgument = 195},
						{connector_name = 'Rocket_Point_28', drawArgument = 188},
						{connector_name = 'Rocket_Point_29', drawArgument = 189},
						{connector_name = 'Rocket_Point_30', drawArgument = 190},
						{connector_name = 'Rocket_Point_31', drawArgument = 191},
						{connector_name = 'Rocket_Point_32', drawArgument = 192},
						{connector_name = 'Rocket_Point_33', drawArgument = 193},
						{connector_name = 'Rocket_Point_34', drawArgument = 194},
						{connector_name = 'Rocket_Point_35', drawArgument = 195}
					}
GT.WS[ws].LN[1].depends_on_unit = MK95_TRACKERS

-- Aft left
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.seasparrow)
GT.WS[ws].area = 'ZA_FAR'
GT.WS[ws].center = 'CENTER_TOWER_10'--POINT CONNECTOR NAME REQUIRED.... NEEDS TO BE PLACED AT CENTER POINT OF THE BACK SAM LAUNCHER
GT.WS[ws].angles_mech = {
							{math.rad(180), math.rad(-180), math.rad(-5), math.rad(95)}
						}
GT.WS[ws].angles = {
					 {math.rad(-165), math.rad(45), math.rad(-5), math.rad(80)},
					 {math.rad(45), math.rad(0), math.rad(10), math.rad(80)},
				   }
GT.WS[ws].drawArgument1 = 19
GT.WS[ws].drawArgument2 = 20
GT.WS[ws].reference_angle_Y = math.rad(0)
GT.WS[ws].LN[1].min_launch_angle = math.rad(35);
GT.WS[ws].LN[1].BR = {
						{connector_name = 'Rocket_Point_20', drawArgument = 188},
						{connector_name = 'Rocket_Point_21', drawArgument = 189},
						{connector_name = 'Rocket_Point_22', drawArgument = 190},
						{connector_name = 'Rocket_Point_23', drawArgument = 191},
						{connector_name = 'Rocket_Point_24', drawArgument = 192},
						{connector_name = 'Rocket_Point_25', drawArgument = 193},
						{connector_name = 'Rocket_Point_26', drawArgument = 194},
						{connector_name = 'Rocket_Point_27', drawArgument = 195},
						{connector_name = 'Rocket_Point_28', drawArgument = 188},
						{connector_name = 'Rocket_Point_29', drawArgument = 189},
						{connector_name = 'Rocket_Point_30', drawArgument = 190},
						{connector_name = 'Rocket_Point_31', drawArgument = 191},
						{connector_name = 'Rocket_Point_32', drawArgument = 192},
						{connector_name = 'Rocket_Point_33', drawArgument = 193},
						{connector_name = 'Rocket_Point_34', drawArgument = 194},
						{connector_name = 'Rocket_Point_35', drawArgument = 195}
					}
GT.WS[ws].LN[1].depends_on_unit = MK95_TRACKERS

--[[
-- MiniCAM FWD
ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].center = 'CENTER_TOWER_11'
GT.WS[ws].area = 'FWD_CAM'   ----- Warning: the names in this line must be present in the GT.DM section
GT.WS[ws].drawArgument1 = 24
GT.WS[ws].drawArgument2 = 25
GT.WS[ws].angles = {
                   {math.rad(180), math.rad(-180), math.rad(-5), math.rad(70)},
                    };
GT.WS[ws].reference_angle_Y = math.rad(0);
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.automatic_gun_25mm);
__LN.BR[1].connector_name = 'POINT_GUN_11'
__LN.fireAnimationArgument = 126;
GT.WS[ws].LN[1].customViewPoint = { "genericHowitzer", {0.0, 0.0, 0.0 }, };
--GT.WS[ws].pointer = "CAMERA_SIGHT"
]]


-- MiniCAM AFT
ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].center = 'CENTER_TOWER_12'
GT.WS[ws].area = 'AFT_CAM'   ----- Warning: the names in this line must be present in the GT.DM section
GT.WS[ws].drawArgument1 = 28
GT.WS[ws].drawArgument2 = 29
GT.WS[ws].angles = {
                   {math.rad(180), math.rad(-180), math.rad(-5), math.rad(70)},
                    };
GT.WS[ws].reference_angle_Y = math.rad(180);
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.automatic_gun_25mm);
__LN.BR[1].connector_name = 'POINT_GUN_12'
__LN.fireAnimationArgument = 126;
GT.WS[ws].LN[1].customViewPoint = { "genericHowitzer", {0.0, 2.0, 0.0 }, };
--GT.WS[ws].pointer = "CAMERA_SIGHT"


GT.Name = "USS Oak Hill LSD-51"
GT.DisplayName = _("USS Oak Hill LSD-51")
GT.Rate = 4000


GT.Sensors = {  
				OPTIC = {"long-range naval optics", "long-range naval LLTV"},
                RADAR = {"seasparrow tr","carrier search radar",},
            };
            

GT.DetectionRange  = GT.airFindDist;
GT.ThreatRange = GT.airWeaponDist;
GT.Singleton   ="yes";
GT.mapclasskey = "P0091000067";
--GT.attribute = {wsType_Navy,wsType_Ship,wsType_ArmedShip, PERRY,  
--GT.attribute = {wsType_Navy,wsType_Ship,wsType_ArmedShip,TICONDEROGA,
GT.attribute        = {
    wsType_Navy, wsType_Ship, wsType_AirCarrier, WSTYPE_PLACEHOLDER,
    "Aircraft Carriers",
    "RADAR_BAND1_FOR_ARM",
    "RADAR_BAND2_FOR_ARM",
    "DetectionByAWACS",
    "Straight_in_approach_type"
   };
GT.Categories = {
					{name = "Armed Ship"},
					{name = "HelicopterCarrier"},
					 { name = "AircraftCarrier" },
		{ name = "AircraftCarrier With Tramplin" },
				};

add_surface_unit(GT)




